Option Strict Off
Imports System.Collections
Imports Microsoft.Win32
Imports System.Text.RegularExpressions

Public Class Class1
    Implements GOverlayPlugin.Interfaces.IPlugin
    Public testvar As Integer = 1

    Private objHost As GOverlayPlugin.Interfaces.IHost
    Public PluginName As String = "CrystalMark DiskInfo"

    Public CM_Registry As RegistryKey = Nothing
    Public CM_DisksAvailable As New Hashtable
    Public CM_Data As New Hashtable
    Public Cache As String


    Public Sub Initialize(ByVal Host As GOverlayPlugin.Interfaces.IHost) Implements GOverlayPlugin.Interfaces.IPlugin.Initialize
        objHost = Host
    End Sub

    Public ReadOnly Property Description() As String Implements GOverlayPlugin.Interfaces.IPlugin.Description
        'Return your plugin name
        Get
            Return "This plugin allows to use the CrystalMark sensors on GOverlay. Developed by TheLaGmAn"
        End Get
    End Property

    Public ReadOnly Property Name() As String Implements GOverlayPlugin.Interfaces.IPlugin.Name
        'Return your plugin name
        Get
            Return PluginName
        End Get
    End Property

    Public ReadOnly Property Display() As String Implements GOverlayPlugin.Interfaces.IPlugin.Display
        'Return the display this plugin belongs to
        Get
            Return "lcdsys"
        End Get
    End Property

    Function CallBack(method As String) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CallBacks
        Try
            Dim returnHT As Hashtable = New Hashtable

            Dim value = 0

            If method = "willrequestvalues" Then
                'Comes here once per run (only if sensors are used thru here)
                grabdata()
            ElseIf method = "willrequestdisplay" Then
                'objHost.DebugMessage("wrd")
            Else
                'objHost.DebugMessage("grabdata: " & method & " >>> " & hwinfo(method)("value"))
                returnHT("value") = CM_Data(method)
                Return returnHT
            End If

        Catch ex As Exception
            objHost.DebugMessage("Error grabbing action : " & method)
        End Try

    End Function

    Function AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.AvailableSensors
        'Create the list of the sensors/elements this plugin has
        'You can access your pluginOptions here as pluginOptions(your_option)        
        Try
            If CM_Registry Is Nothing Then
                CM_Registry = Registry.CurrentUser.OpenSubKey(pluginOptions("regkey"))
            End If
            Dim diskCount = CM_Registry.GetValue("DiskCount")
            Dim x As Integer = 0

            Dim sensors As New System.Collections.Generic.Dictionary(Of String, String)
            If diskCount > 0 Then
                For x = 0 To diskCount - 1
                    Dim diskName = CM_Registry.GetValue("Disk" & x)
                    CM_DisksAvailable(x) = New Hashtable
                    CM_DisksAvailable(x)("diskName") = diskName
                    CM_DisksAvailable(x)("reg") = Registry.CurrentUser.OpenSubKey(pluginOptions("regkey") & diskName)

                    sensors.Add("CM." & x & ".DiskSize", diskName & ": Disk Size")
                    sensors.Add("CM." & x & ".DriveLetter", diskName & ": Drive Letter")
                    sensors.Add("CM." & x & ".Model", diskName & ": Model")
                    sensors.Add("CM." & x & ".Temperature", diskName & ": Temperature")
                    sensors.Add("CM." & x & ".TemperatureClass", diskName & ": Temperature Class")
                Next
            End If

            Return sensors
        Catch ex As Exception
            objHost.DebugMessage("Error loading sensors, Is CristalMark running with External Applications enabled?" & ex.Message & ": " & ex.StackTrace)
            'MsgBox(ex.Message & ":: " & ex.StackTrace)
        End Try
    End Function


    Function LCDSys2_AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_AvailableSensors
        Return AvailableSensors(pluginOptions)
    End Function

    Function SensorHasCustomDraw(sensor_name As String) As Boolean Implements GOverlayPlugin.Interfaces.IPlugin.SensorHasCustomDraw
        'All sensors are drawn with GOverlay default drawing
        Return False
    End Function

    Function ComboBoxes() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.ComboBoxes
        Return New Hashtable
    End Function

    Public Function SetDefaultOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.SetDefaultOptions
        'Set the default values you want to have on your sensor when its created, if the user doesnt change any option, he will have this settings
        Return elementData
    End Function

    Public Function CreateOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CreateOptions
        'Set the options the user will have when clicking on the element
        'The available option_types are:
        'Text: Input text
        'Combo3: Combo with options (Enabled=0, Disabled=1)
        'Sensors: Combo with available sensors
        'ColorBasic: Combo with basic colors for the regular text font
        'ColorRGB: Combo with common RGB colors = 16bitinteger
        'ComboOnOff: Combo with options (Disabled=0, Enabled=1)
        'ComboYesNo: Combo with options (Yes=Yes, No=No)
        'TextSize: Combo with options (Extra Small=4, Very Small=5, Small=10, Normal=15, Big=20, Very Big=30, Extreme=40)
        'FontStyle2: Combo with options (Regular Font=0, Square Font=1, Numbers Font 1=2
        'Orientation: Combo with options (Horizontal=0, Vertical=1)
        'Here you can also load your custom comboboxes
        Return New Hashtable

    End Function

    Public Function LCDSys2_CreateOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_CreateOptions
        'Set the options the user will have when clicking on the element
        'The available option_types are:
        'Text: Input text
        'Combo3: Combo with options (Enabled=0, Disabled=1)
        'Sensors: Combo with available sensors
        'ColorRGB: Combo with common RGB colors = 16bitinteger
        'ComboOnOff: Combo with options (Disabled=0, Enabled=1)
        'ComboYesNo: Combo with options (Yes=Yes, No=No)
        'FontStyle: Combo with options of the fonts the user has installed
        'Orientation: Combo with options (Horizontal=0, Vertical=1)
        'Alignment: Left=-1,Center=0,Right=1
        'Here you can also load your custom comboboxes

        'No options because GOverlay draws instead of us
        Return New Hashtable
    End Function

    Public Function PluginOptionsDefault() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptionsDefault
        'Set the default values you want to have on plugin, if the user doesnt change any option, he will have this settings
        Dim options As New Hashtable
        options("regkey") = "Software\Crystal Dew World\CrystalDiskInfo\"
        Return options
    End Function
    Public Function PluginOptions(pluginCurrentOptions As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptions
        'Set the options the user will have when going to the plugins tab and clicking on your plugin
        'The availalbe option_type are teh same as CreateOptions function
        Dim options As New Hashtable
        'Option: option_index as integer, option_data as ArrayList
        'Option_Data: option_type as string, option_label as string, option_name as string (no spaces, no _)
        options.Add(0, New ArrayList({"Text", "Registry Path", "regkey"}))
        Return options
    End Function

    Public Function grabdata()
        Dim pluginOptions = objHost.AccessHost("plugin_options", "CrystalMark DiskInfo", "regkey", "")

   
        If CM_Registry Is Nothing Then
            CM_Registry = Registry.CurrentUser.OpenSubKey(PluginOptions("regkey"))
        End If
        Dim diskCount As Integer = CM_Registry.GetValue("DiskCount")
        Dim x As Integer = 0
        Dim sensors As New System.Collections.Generic.Dictionary(Of String, String)
        If diskCount > 0 Then
            For x = 0 To diskCount - 1
                If CM_DisksAvailable.ContainsKey(x) Then
                    CM_Data("CM." & x & ".DiskSize") = CM_DisksAvailable(x)("reg").getvalue("DiskSize")
                    CM_Data("CM." & x & ".DriveLetter") = CM_DisksAvailable(x)("reg").getvalue("DriveLetter")
                    CM_Data("CM." & x & ".Model") = CM_DisksAvailable(x)("reg").getvalue("Model")
                    CM_Data("CM." & x & ".Temperature") = CM_DisksAvailable(x)("reg").getvalue("Temperature")
                    CM_Data("CM." & x & ".TemperatureClass") = CM_DisksAvailable(x)("reg").getvalue("TemperatureClass")
                End If
            Next
        End If

    End Function

    Public Function DisplayOnLCD(sensorId As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.DisplayOnLCD
        Return New ArrayList
    End Function

    Public Function LCDSys2_DisplayOnLCD(sensorId As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_DisplayOnLCD
        'GOverlay draws instead of us
        Return New ArrayList
    End Function
    Public Function convertcolorto16bit(cr, cg, cb)

        Dim R As Double
        Dim G As Double
        Dim B As Double

        R = cr / 256 * 32
        G = cg / 256 * 64
        B = cb / 256 * 32

        R = Math.Floor(R)
        G = Math.Floor(G)
        B = Math.Floor(B)

        Dim final As Int32 = (CInt(R) << 11)
        final = final + Int(G << 5)
        final = final + Int(B)

        Return final

    End Function
End Class